/*
 * Decompiled with CFR 0.152.
 */
package MainApp;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WaitCanvas
extends Canvas {
    private int mCount = 0;
    private int mMaximum = 36;
    private int mInterval = 100;
    private int mWidth = this.getWidth();
    private int mHeight = this.getHeight();
    private int mX;
    private int mY;
    private int mRadius;
    private String mMessage = "... \u0627\u0646\u062a\u0638\u0631 ...";

    public WaitCanvas() {
        int halfWidth = (this.mWidth - this.mRadius) / 2;
        int halfHeight = (this.mHeight - this.mRadius) / 2;
        this.mRadius = Math.min(halfWidth, halfHeight);
        this.mX = halfWidth - this.mRadius / 2;
        this.mY = halfHeight - this.mRadius / 2;
        TimerTask task = new TimerTask(){

            public void run() {
                WaitCanvas.this.mCount = (WaitCanvas.this.mCount + 1) % WaitCanvas.this.mMaximum;
                WaitCanvas.this.repaint();
            }
        };
        Timer timer = new Timer();
        timer.schedule(task, 0L, (long)this.mInterval);
    }

    public void setMessage(String s) {
        this.mMessage = s;
        this.repaint();
    }

    public void paint(Graphics g) {
        int theta = -(this.mCount * 360 / this.mMaximum);
        g.setColor(0xFFFF99);
        g.fillRect(0, 0, this.mWidth, this.mHeight);
        g.setColor(0xCC0000);
        g.drawArc(this.mX, this.mY, this.mRadius, this.mRadius, 0, 360);
        g.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, theta + 90, 90);
        g.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, theta + 270, 90);
        if (this.mMessage != null) {
            Font fontMedPlain = Font.getFont((int)0, (int)1, (int)0);
            g.setFont(fontMedPlain);
            g.drawString(this.mMessage, this.mWidth / 2, this.mHeight - 10, 33);
        }
    }
}

