/*
 * Decompiled with CFR 0.152.
 */
package MainApp;

import MainApp.SMSSender;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class SMSReceive
extends MIDlet
implements CommandListener,
Runnable,
MessageListener {
    Command exitCommand = new Command("Exit", 7, 2);
    Command replyCommand = new Command("Reply", 4, 1);
    Alert content;
    Display display;
    Thread thread;
    String[] connections;
    boolean done;
    String smsPort = this.getAppProperty("SMS-Port");
    MessageConnection smsconn;
    Message msg;
    String senderAddress;
    Alert sendingMessageAlert;
    SMSSender sender;
    Displayable resumeScreen;

    public SMSReceive() {
        this.display = Display.getDisplay((MIDlet)this);
        this.content = new Alert("SMS Receive");
        this.content.setTimeout(-2);
        this.content.addCommand(this.exitCommand);
        this.content.setCommandListener((CommandListener)this);
        this.content.setString("Receiving...");
        this.sendingMessageAlert = new Alert("SMS", null, null, AlertType.INFO);
        this.sendingMessageAlert.setTimeout(5000);
        this.sendingMessageAlert.setCommandListener((CommandListener)this);
        this.resumeScreen = this.content;
    }

    public void startApp() {
        String smsConnection = "sms://:" + this.smsPort;
        if (this.smsconn == null) {
            try {
                this.smsconn = (MessageConnection)Connector.open((String)smsConnection);
                this.smsconn.setMessageListener((MessageListener)this);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.connections = PushRegistry.listConnections((boolean)true);
        if (this.connections == null || this.connections.length == 0) {
            this.content.setString("Waiting for SMS on port " + this.smsPort + "...");
        }
        this.done = false;
        this.thread = new Thread(this);
        this.thread.start();
        this.display.setCurrent(this.resumeScreen);
    }

    public void notifyIncomingMessage(MessageConnection conn) {
        if (this.thread == null) {
            this.done = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        try {
            this.msg = this.smsconn.receive();
            if (this.msg != null) {
                this.senderAddress = this.msg.getAddress();
                this.content.setTitle("From: " + this.senderAddress);
                if (this.msg instanceof TextMessage) {
                    this.content.setString(((TextMessage)this.msg).getPayloadText());
                } else {
                    StringBuffer buf = new StringBuffer();
                    byte[] data = ((BinaryMessage)this.msg).getPayloadData();
                    for (int i = 0; i < data.length; ++i) {
                        int intData = data[i] & 0xFF;
                        if (intData < 16) {
                            buf.append("0");
                        }
                        buf.append(Integer.toHexString(intData));
                        buf.append(' ');
                    }
                    this.content.setString(buf.toString());
                }
                this.content.addCommand(this.replyCommand);
                this.display.setCurrent((Displayable)this.content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pauseApp() {
        this.done = true;
        this.thread = null;
        this.resumeScreen = this.display.getCurrent();
    }

    public void destroyApp(boolean unconditional) {
        this.done = true;
        this.thread = null;
        if (this.smsconn != null) {
            try {
                this.smsconn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command c, Displayable s) {
        try {
            if (c == this.exitCommand || c == Alert.DISMISS_COMMAND) {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

