/*
 * Decompiled with CFR 0.152.
 */
package MainApp;

import MainApp.FirstIndexMIDlet;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class VideoCanvas2
extends Canvas
implements CommandListener,
PlayerListener {
    private PlayerController controller;
    private FirstIndexMIDlet midlet;
    private String returnScreen;
    private String videoFile;
    private Command replayCommand;
    private Command backCommand;
    private Player player;
    private boolean initDone;
    private boolean playPending = false;

    VideoCanvas2(FirstIndexMIDlet midlet, String returnScreen, String videoFile) {
        this.midlet = midlet;
        this.returnScreen = returnScreen;
        this.videoFile = videoFile;
        this.controller = new PlayerController();
        this.replayCommand = new Command("Replay", 4, 1);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.addCommand(this.replayCommand);
        this.setCommandListener(this);
    }

    void prepareToPlay() {
        this.controller.start();
        this.playPending = true;
    }

    public void showNotify() {
        if (this.playPending) {
            this.playPending = false;
            this.controller.playVideo();
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.midlet.clsPackage.iBackgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.replayCommand) {
            this.controller.playVideo();
        } else if (c == this.backCommand) {
            this.discardPlayer();
            this.midlet.doCommandAction(this.returnScreen);
        }
    }

    void doStop() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    void doPlay() {
        try {
            int state;
            if (!this.initDone || this.player == null) {
                this.initPlayer();
            }
            if ((state = this.player.getState()) == 0) {
                this.player.prefetch();
            } else if (state == 100) {
                this.player.realize();
            } else if (state == 200) {
                this.player.prefetch();
            }
            VideoControl videoControl = (VideoControl)this.player.getControl("VideoControl");
            if (videoControl == null) {
                this.midlet.alertError("VideoControl not supported");
            } else {
                videoControl.initDisplayMode(1, (Object)this);
                videoControl.setDisplayLocation(0, 0);
                videoControl.setDisplaySize(this.getWidth(), this.getHeight());
                videoControl.setVisible(true);
            }
            this.player.start();
        }
        catch (MediaException me) {
            this.discardPlayer();
            this.midlet.alertError("MediaException: " + me.getMessage());
        }
        catch (SecurityException se) {
            this.discardPlayer();
            this.midlet.alertError("SecurityException: " + se.getMessage());
        }
        catch (Exception e) {
            this.discardPlayer();
            this.midlet.alertError("Exception: " + e.getMessage());
        }
    }

    void initPlayer() {
        try {
            this.initDone = false;
            if (this.videoFile == null) {
                this.midlet.alertError("No video file specified");
                return;
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(this.videoFile);
            this.player = Manager.createPlayer((InputStream)is, (String)"video/3gpp");
            this.player.addPlayerListener((PlayerListener)this);
            this.player.prefetch();
            this.player.realize();
            this.initDone = true;
        }
        catch (IOException ioe) {
            this.discardPlayer();
            this.midlet.alertError("IOException: " + ioe.getMessage());
        }
        catch (MediaException me) {
            this.discardPlayer();
            this.midlet.alertError("MediaException: " + me.getMessage());
        }
        catch (SecurityException se) {
            this.discardPlayer();
            this.midlet.alertError("SecurityException: " + se.getMessage());
        }
        catch (Exception ex) {
            this.discardPlayer();
            this.midlet.alertError("Exception: " + ex.getMessage());
        }
    }

    void discardPlayer() {
        if (this.player != null) {
            this.controller.setStopped();
            this.player.close();
            this.player = null;
        }
    }

    public void playerUpdate(Player p, String event, Object eventData) {
    }

    public class PlayerController
    extends Thread {
        private boolean running;
        private Object controllLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                VideoCanvas2.this.doStop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopped() {
            this.running = false;
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VideoCanvas2.this.doPlay();
            this.running = true;
            while (this.running) {
                try {
                    Object object = this.controllLock;
                    synchronized (object) {
                        this.controllLock.wait();
                        if (!this.running) {
                            break;
                        }
                        VideoCanvas2.this.doPlay();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

