/*
 * Decompiled with CFR 0.152.
 */
package MainApp;

import MainApp.Class_NodeDetails;
import MainApp.FirstIndexMIDlet;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

class VideoCanvas
extends Canvas
implements CommandListener,
PlayerListener {
    private PlayerController controller;
    private FirstIndexMIDlet midlet;
    Class_NodeDetails clsNode;
    Command cmdOK;
    Command cmdBack;
    Command cmd1;
    Command cmd2;
    Command cmd3;
    Command cmd4;
    private Player player;
    private boolean initDone;
    private boolean playPending = false;

    public void keyPressed(int code) {
        int game = this.getGameAction(code);
        switch (game) {
            case 8: {
                this.commandAction(this.cmdOK, (Displayable)this);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    VideoCanvas(FirstIndexMIDlet midlet) {
        this.midlet = midlet;
        this.setCommandListener(this);
    }

    void prepareToPlay(Class_NodeDetails tclsNode) {
        this.clsNode = tclsNode;
        try {
            this.removeCommand(this.cmdBack);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            this.removeCommand(this.cmdOK);
        }
        catch (Exception x) {
            // empty catch block
        }
        String okCmd = this.clsNode.sOKIDT;
        String bkCmd = this.clsNode.sBackIDT;
        if (okCmd.compareTo("") != 0) {
            this.cmdOK = new Command(okCmd, 4, 1);
            this.addCommand(this.cmdOK);
        }
        if (bkCmd.compareTo("") != 0) {
            this.cmdBack = new Command(bkCmd, 2, 1);
            this.addCommand(this.cmdBack);
        }
        try {
            this.removeCommand(this.cmd1);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            this.removeCommand(this.cmd2);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            this.removeCommand(this.cmd3);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            this.removeCommand(this.cmd4);
        }
        catch (Exception x) {
            // empty catch block
        }
        if (tclsNode.sCommand_Title1.compareTo("") != 0) {
            this.cmd1 = new Command(tclsNode.sCommand_Title1, 1, 2);
            this.addCommand(this.cmd1);
        }
        if (tclsNode.sCommand_Title2.compareTo("") != 0) {
            this.cmd2 = new Command(tclsNode.sCommand_Title2, 1, 3);
            this.addCommand(this.cmd2);
        }
        if (tclsNode.sCommand_Title3.compareTo("") != 0) {
            this.cmd3 = new Command(tclsNode.sCommand_Title3, 1, 4);
            this.addCommand(this.cmd3);
        }
        if (tclsNode.sCommand_Title4.compareTo("") != 0) {
            this.cmd4 = new Command(tclsNode.sCommand_Title4, 1, 5);
            this.addCommand(this.cmd4);
        }
        try {
            this.controller = new PlayerController();
        }
        catch (Exception x) {
            // empty catch block
        }
        this.controller.start();
        this.playPending = true;
    }

    public void showNotify() {
        if (this.playPending) {
            this.playPending = false;
            this.controller.playVideo();
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.midlet.clsPackage.iBackgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void commandAction(Command cmd, Displayable d) {
        this.discardPlayer();
        if (cmd == this.cmdBack) {
            if (this.clsNode.sBackID.compareTo("0") == 0) {
                this.midlet.doCommandAction(this.clsNode.sParent_Category_Id);
            } else {
                this.midlet.doCommandAction(this.clsNode.sBackID);
            }
        } else if (cmd == this.cmdOK) {
            if (this.clsNode.sAdditionalOrderText.compareTo("") != 0) {
                this.midlet.SendMsg(this.clsNode.sAdditionalOrderText, Integer.parseInt(this.clsNode.sOKID) != 0 ? this.clsNode.sOKID : this.clsNode.sCategory_Id, false);
            } else if (Integer.parseInt(this.clsNode.sOKID) != 0) {
                this.midlet.doCommandAction(this.clsNode.sOKID);
            } else {
                this.controller.stopVideo();
                this.controller = new PlayerController();
                this.controller.start();
            }
        } else if (cmd == this.cmd1) {
            if (this.clsNode.sCommand_Text1.compareTo("") != 0) {
                this.midlet.SendMsg(this.clsNode.sCommand_Text1, this.clsNode.sCategory_Id, false);
            }
        } else if (cmd == this.cmd2) {
            if (this.clsNode.sCommand_Text2.compareTo("") != 0) {
                this.midlet.SendMsg(this.clsNode.sCommand_Text2, this.clsNode.sCategory_Id, false);
            }
        } else if (cmd == this.cmd3) {
            if (this.clsNode.sCommand_Text3.compareTo("") != 0) {
                this.midlet.SendMsg(this.clsNode.sCommand_Text3, this.clsNode.sCategory_Id, false);
            }
        } else if (cmd == this.cmd4 && this.clsNode.sCommand_Text4.compareTo("") != 0) {
            this.midlet.SendMsg(this.clsNode.sCommand_Text4, this.clsNode.sCategory_Id, false);
        }
    }

    void doStop() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    void doPlay() {
        try {
            int state;
            if (!this.initDone || this.player == null) {
                this.initPlayer();
            }
            if ((state = this.player.getState()) == 0) {
                this.player.prefetch();
            } else if (state == 100) {
                this.player.realize();
            } else if (state == 200) {
                this.player.prefetch();
            }
            VideoControl videoControl = (VideoControl)this.player.getControl("VideoControl");
            if (videoControl == null) {
                this.midlet.alertError("VideoControl not supported");
            } else {
                videoControl.initDisplayMode(1, (Object)this);
                videoControl.setDisplayLocation(0, 0);
                videoControl.setDisplaySize(this.getWidth() - 10, this.getHeight() - 10);
                videoControl.setVisible(true);
            }
            this.player.start();
        }
        catch (MediaException me) {
            this.discardPlayer();
            this.midlet.alertError("MediaException: " + me.getMessage());
        }
        catch (SecurityException se) {
            this.discardPlayer();
            this.midlet.alertError("SecurityException: " + se.getMessage());
        }
        catch (Exception e) {
            this.discardPlayer();
            this.midlet.alertError("Exception: " + e.getMessage());
        }
    }

    void initPlayer() {
        try {
            this.initDone = false;
            if (this.clsNode.sVideoURL == null) {
                this.midlet.alertError("No video file specified");
                return;
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/res/" + this.clsNode.sVideoURL);
            this.player = Manager.createPlayer((InputStream)is, (String)"video/3gpp");
            this.player.addPlayerListener((PlayerListener)this);
            this.player.prefetch();
            this.player.realize();
            this.initDone = true;
        }
        catch (IOException ioe) {
            this.discardPlayer();
            this.midlet.alertError("IOException: " + ioe.getMessage());
        }
        catch (MediaException me) {
            this.discardPlayer();
            this.midlet.alertError("MediaException: " + me.getMessage());
        }
        catch (SecurityException se) {
            this.discardPlayer();
            this.midlet.alertError("SecurityException: " + se.getMessage());
        }
        catch (Exception ex) {
            this.discardPlayer();
            this.midlet.alertError("Exception: " + ex.getMessage());
        }
    }

    void discardPlayer() {
        if (this.player != null) {
            this.controller.setStopped();
            this.player.close();
            this.player = null;
        }
    }

    public void playerUpdate(Player p, String event, Object eventData) {
    }

    public class PlayerController
    extends Thread {
        private boolean running;
        private Object controllLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopVideo() {
            Object object = this.controllLock;
            synchronized (object) {
                VideoCanvas.this.doStop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopped() {
            this.running = false;
            Object object = this.controllLock;
            synchronized (object) {
                this.controllLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VideoCanvas.this.doPlay();
            this.running = true;
            while (this.running) {
                try {
                    Object object = this.controllLock;
                    synchronized (object) {
                        this.controllLock.wait();
                        if (!this.running) {
                            break;
                        }
                        VideoCanvas.this.doPlay();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

