/*
 * Decompiled with CFR 0.152.
 */
package MainApp;

import MainApp.FirstIndexMIDlet;
import MainApp.Media;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class PlayerPool
implements PlayerListener {
    protected Vector players;
    protected Vector medias;
    protected FirstIndexMIDlet midlet;
    protected int latency;
    boolean supportMultiPlayer = true;
    private int volumeLevel = 100;
    private long stopTime = Long.MAX_VALUE;
    private int realizedSoundIndex;

    public PlayerPool(FirstIndexMIDlet midlet, int latency) {
        this.midlet = midlet;
        this.latency = latency;
        this.players = new Vector();
        this.medias = new Vector();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
    }

    public boolean isMediaSupported(String mimeType) {
        String[] types = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < types.length; ++i) {
            if (!mimeType.toLowerCase().equals(types[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void addMedia(Media media) throws MediaException {
        String mimeType = media.getType();
        if (!this.isMediaSupported(mimeType)) {
            throw new MediaException("Type " + mimeType + " is not supported!");
        }
        this.addSoundObject(media);
    }

    public boolean supportsMulplePlayers() {
        return this.supportMultiPlayer;
    }

    public void addToneSequence(byte[] sequence) throws MediaException {
        if (!this.isMediaSupported("audio/x-tone-seq")) {
            throw new MediaException("Tone (audio/x-tone-seq) is not supported!");
        }
        this.addSoundObject(sequence);
    }

    private Player createTonePlayer(byte[] sequence) throws MediaException, IOException {
        Player player = Manager.createPlayer((String)"device://tone");
        player.addPlayerListener((PlayerListener)this);
        player.realize();
        ToneControl tc = (ToneControl)player.getControl("ToneControl");
        tc.setSequence(sequence);
        return player;
    }

    private Player createPlayer(Object media) throws MediaException, IOException {
        if (media instanceof byte[]) {
            return this.createTonePlayer((byte[])media);
        }
        return this.createPlayer((Media)media);
    }

    private Player createPlayer(Media media) throws MediaException, IOException {
        InputStream is = media.getInputStream();
        String mediaType = media.getType();
        Player player = Manager.createPlayer((InputStream)is, (String)mediaType);
        player.addPlayerListener((PlayerListener)this);
        player.realize();
        player.prefetch();
        return player;
    }

    public void releaseResources() {
        this.discardAll();
        this.players.removeAllElements();
        this.medias.removeAllElements();
    }

    public void setVolumeLevel(int volume) {
        this.volumeLevel = volume;
        this.updateVolumeLevel();
    }

    public void setStopTime(long time) {
        this.stopTime = time;
        this.updateStopTime();
    }

    public void playSound(int index) throws MediaException {
        if (this.supportMultiPlayer) {
            if (index >= 0 && index < this.players.size()) {
                Player player = (Player)this.players.elementAt(index);
                this.startPlayer(player);
            }
        } else {
            if (index == this.realizedSoundIndex) {
                Player player = (Player)this.players.elementAt(0);
                this.startPlayer(player);
                return;
            }
            this.discardAll();
            this.players.removeAllElements();
            try {
                Object obj = this.medias.elementAt(index);
                Player player = this.createPlayer(obj);
                this.players.addElement(player);
                this.updateStopTime();
                this.updateVolumeLevel();
                this.realizedSoundIndex = index;
                this.startPlayer(player);
            }
            catch (IOException ioe) {
                this.midlet.alertError("IOException: " + ioe.getMessage());
            }
        }
    }

    private void startPlayer(Player player) {
        try {
            if (player != null) {
                if (player.getState() == 100) {
                    player.prefetch();
                    player.realize();
                }
                if (player.getState() != 0) {
                    Thread.sleep(this.latency);
                    player.start();
                }
            }
            Thread.sleep(this.latency);
        }
        catch (InterruptedException e) {
        }
        catch (MediaException e) {
            this.discardPlayer(player);
            this.midlet.alertError("MediaException: " + e.getMessage());
        }
    }

    public void discardPlayer(Player player) {
        if (player != null) {
            player.close();
        }
    }

    public void discardAll() {
        for (int i = 0; i < this.players.size(); ++i) {
            Player player = (Player)this.players.elementAt(i);
            this.discardPlayer(player);
        }
    }

    private void updateVolumeLevel() {
        int size = this.players.size();
        for (int i = 0; i < size; ++i) {
            Player player = (Player)this.players.elementAt(i);
            VolumeControl control = (VolumeControl)player.getControl("VolumeControl");
            control.setLevel(this.volumeLevel);
        }
    }

    private void updateStopTime() {
        int size = this.players.size();
        for (int i = 0; i < size; ++i) {
            Player player = (Player)this.players.elementAt(i);
            StopTimeControl control = (StopTimeControl)player.getControl("StopTimeControl");
            control.setStopTime(this.stopTime);
        }
    }

    private void addSoundObject(Object sndObject) throws MediaException {
        block9: {
            if (!this.supportMultiPlayer) {
                this.medias.addElement(sndObject);
            } else {
                try {
                    Player player = this.createPlayer(sndObject);
                    this.players.addElement(player);
                    this.medias.addElement(sndObject);
                }
                catch (MediaException se) {
                    if (this.supportMultiPlayer && this.players.size() == 1) {
                        Player failedPlayer = (Player)this.players.elementAt(0);
                        this.discardPlayer(failedPlayer);
                        this.players.removeElementAt(0);
                        try {
                            Player player = this.createPlayer(sndObject);
                            this.supportMultiPlayer = false;
                            this.medias.addElement(sndObject);
                            this.players.removeAllElements();
                            this.players.addElement(player);
                            this.realizedSoundIndex = this.medias.size() - 1;
                        }
                        catch (MediaException me) {
                            throw me;
                        }
                        catch (IOException ioe) {
                            this.midlet.alertError("IOException: " + ioe.getMessage());
                            break block9;
                        }
                    }
                    throw se;
                }
                catch (IOException ioe) {
                    this.midlet.alertError("IOException: " + ioe.getMessage());
                }
            }
        }
    }
}

